import MirrorsByRegion from './mirrorsByRegion.js';
import { processUrl } from './processUrl.js';
function getDateTime() {
    const now = new Date();
    return now.toISOString().split('T')[0];
}
function generateMirrorlist(mirrors = []) {
    const httpMirrors = mirrors.filter(m => processUrl(m.url).mirrorListable);
    const mirrorsByRegion = new MirrorsByRegion(httpMirrors);
    const lines = [
        '##',
        '## Artix Linux repository mirrorlist',
        `## Generated on ${getDateTime()} by artix-mlg`,
        '##',
        '',
        '# Artix mirrors',
        '# Use rankmirrors(1) to get a list of the fastest mirrors for your location,',
        '# e.g.: rankmirrors -v -n 5 /etc/pacman.d/mirrorlist',
        '# Then put the resulting list on top of this file.',
        '',
        '# Default mirrors'
    ];
    httpMirrors.filter(m => m.default).forEach(m => lines.push(`Server = ${m.url}`));
    lines.push('');
    mirrorsByRegion.printMirrors(lines);
    return lines.join('\n');
}
export default generateMirrorlist;
export { generateMirrorlist };
//# sourceMappingURL=mirrorlist.js.map