#!/bin/sh

_do_zpool_export() {
	ret=0
	errs=""
	final="${1}"

	info "ZFS: Exporting ZFS storage pools..."
	errs=$(zpool export -aF 2>&1)
	ret=$?
	[ -z "${errs}" ] || echo "${errs}" | vwarn
	if [ "x${ret}" != "x0" ]; then
		info "ZFS: There was a problem exporting pools."
	fi

	if [ "x${final}" != "x" ]; then
		info "ZFS: pool list"
		zpool list 2>&1 | vinfo
	fi

	return ${ret}
}

if command -v zpool >/dev/null; then
	_do_zpool_export "${1}"
else
	:
fi
