import { resolveCountry } from './resolveCountry.js';
class MirrorsByRegion {
    mirrorsByCountry = {};
    countriesByContinent = {};
    continents = ['Europe', 'North America', 'South America', 'Asia', 'Africa', 'Oceania', 'Antarctica'];
    constructor(mirrors) {
        mirrors.forEach(m => {
            const country = m.country;
            const continent = resolveCountry(country)?.continent;
            this.countriesByContinent[continent] ||= [];
            if (!(country in this.mirrorsByCountry)) {
                this.mirrorsByCountry[country] = [];
                this.countriesByContinent[continent].push(country);
            }
            this.mirrorsByCountry[country].push(`Server = ${m.url}`);
        });
        for (let continent in this.countriesByContinent) {
            this.countriesByContinent[continent].sort();
        }
    }
    sortCountryMirrors() {
        for (let country in this.mirrorsByCountry) {
            this.mirrorsByCountry[country].sort();
        }
    }
    printMirrors(lines = []) {
        this.continents.forEach(continent => {
            const countries = this.countriesByContinent[continent];
            if (!countries || !countries.length) {
                return;
            }
            lines.push(`## ${continent}`);
            countries.forEach(country => {
                lines.push(`# ${country}`);
                lines.push.apply(lines, this.mirrorsByCountry[country]);
            });
            lines.push(``);
        });
        return lines;
    }
}
export default MirrorsByRegion;
export { MirrorsByRegion };
//# sourceMappingURL=mirrorsByRegion.js.map