/* === This file is part of Calamares - <http://github.com/calamares> ===
 *
 *   Copyright 2015, Teo Mrnjavac <teo@kde.org>
 *   Copyright 2016, Luca Giambonini <almack@chakralinux.org>
 *
 *   Calamares is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Calamares is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Calamares. If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0;
import calamares.slideshow 1.0;

/* Tested with slide images of 1800x1200 and 1632x1248 pixels */

Presentation
{
    id: presentation

    Timer {
        interval: 5000
        running: true
        repeat: true
        onTriggered: presentation.goToNextSlide()
    }

    Slide {
       Image {
            source: "background.png"
            width: parent.width * 4; height: parent.height * 4
            fillMode: Image.Stretch
            anchors.centerIn: parent
        }
        Image {
            source: "thanks.png"
            width: parent.width * 1.12; height: parent.height * 1.5
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: - parent.height / 16
        }
    }

    Slide {
       Image {
            source: "background.png"
            width: parent.width * 4; height: parent.height * 4
            fillMode: Image.Stretch
            anchors.centerIn: parent
        }
        Image {
            source: "artix.png"
            width: parent.width * 1.12; height: parent.height * 1.5
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: - parent.height / 16
        }
    }

    Slide {
       Image {
            source: "background.png"
            width: parent.width * 4; height: parent.height * 4
            fillMode: Image.Stretch
            anchors.centerIn: parent
        }
        Image {
            source: "tools.png"
            width: parent.width * 1.12; height: parent.height * 1.5
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: - parent.height / 16
        }
    }

    Slide {
       Image {
            source: "background.png"
            width: parent.width * 4; height: parent.height * 4
            fillMode: Image.Stretch
            anchors.centerIn: parent
        }
        Image {
            source: "desktops.png"
            width: parent.width * 1.12; height: parent.height * 1.5
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: - parent.height / 16
        }
    }

    Slide {
       Image {
            source: "background.png"
            width: parent.width * 4; height: parent.height * 4
            fillMode: Image.Stretch
            anchors.centerIn: parent
        }
        Image {
            source: "productivity.png"
            width: parent.width * 1.12; height: parent.height * 1.5
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: - parent.height / 16
        }
    }

    Slide {
       Image {
            source: "background.png"
            width: parent.width * 4; height: parent.height * 4
            fillMode: Image.Stretch
            anchors.centerIn: parent
        }
        Image {
            source: "browsers.png"
            width: parent.width * 1.12; height: parent.height * 1.5
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: - parent.height / 16
        }
    }

    Slide {
       Image {
            source: "background.png"
            width: parent.width * 4; height: parent.height * 4
            fillMode: Image.Stretch
            anchors.centerIn: parent
        }
        Image {
            source: "office.png"
            width: parent.width * 1.12; height: parent.height * 1.5
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: - parent.height / 16
        }
    }

    Slide {
       Image {
            source: "background.png"
            width: parent.width * 4; height: parent.height * 4
            fillMode: Image.Stretch
            anchors.centerIn: parent
        }
        Image {
            source: "multimedia.png"
            width: parent.width * 1.12; height: parent.height * 1.5
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: - parent.height / 16
        }
    }

    Slide {
       Image {
            source: "background.png"
            width: parent.width * 4; height: parent.height * 4
            fillMode: Image.Stretch
            anchors.centerIn: parent
        }
        Image {
            source: "web.png"
            width: parent.width * 1.12; height: parent.height * 1.5
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: - parent.height / 16
        }
    }

    Slide {
       Image {
            source: "background.png"
            width: parent.width * 4; height: parent.height * 4
            fillMode: Image.Stretch
            anchors.centerIn: parent
        }
        Image {
            source: "packages1.png"
            width: parent.width * 1.12; height: parent.height * 1.5
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: - parent.height / 16
        }
    }

    Slide {
       Image {
            source: "background.png"
            width: parent.width * 4; height: parent.height * 4
            fillMode: Image.Stretch
            anchors.centerIn: parent
        }
        Image {
            source: "packages2.png"
            width: parent.width * 1.12; height: parent.height * 1.5
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: - parent.height / 16
        }
    }

    Slide {
       Image {
            source: "background.png"
            width: parent.width * 4; height: parent.height * 4
            fillMode: Image.Stretch
            anchors.centerIn: parent
        }
        Image {
            source: "packages3.png"
            width: parent.width * 1.12; height: parent.height * 1.5
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: - parent.height / 16
        }
    }

    Slide {
       Image {
            source: "background.png"
            width: parent.width * 4; height: parent.height * 4
            fillMode: Image.Stretch
            anchors.centerIn: parent
        }
        Image {
            source: "packages4.png"
            width: parent.width * 1.12; height: parent.height * 1.5
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: - parent.height / 16
        }
    }

    Slide {
       Image {
            source: "background.png"
            width: parent.width * 4; height: parent.height * 4
            fillMode: Image.Stretch
            anchors.centerIn: parent
        }
        Image {
            source: "customise.png"
            width: parent.width * 1.12; height: parent.height * 1.5
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: - parent.height / 16
        }
    }

    Slide {
       Image {
            source: "background.png"
            width: parent.width * 4; height: parent.height * 4
            fillMode: Image.Stretch
            anchors.centerIn: parent
        }
        Image {
            source: "rolling.png"
            width: parent.width * 1.12; height: parent.height * 1.5
            fillMode: Image.PreserveAspectFit
            anchors.centerIn: parent
            anchors.verticalCenterOffset: - parent.height / 16
        }
    }
}
