/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.AggregateByteArray;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.CharacterSet;

class T2CCharByteArray
extends AggregateByteArray {
    private static final String CLASS_NAME = T2CCharByteArray.class.getName();
    char[] charArray;
    DBConversion conversion;

    T2CCharByteArray(Diagnosable diagnosable, char[] _charArray, ByteArray _extension) {
        super(diagnosable, PhysicalConnection.EMPTY_BYTE_ARRAY, _extension);
        this.charArray = _charArray;
    }

    @Override
    long length() {
        return (long)this.charArray.length + this.extension.length();
    }

    void setChars(char[] _chars) {
        this.charArray = _chars;
    }

    void setDBConversion(DBConversion _conversion) {
        this.conversion = _conversion;
    }

    @Override
    char[] getChars(long offset, int lengthInChars, CharacterSet charSet, int[] out_lengthInChars) throws SQLException {
        if (offset < (long)this.charArray.length) {
            char[] returnValue = new char[lengthInChars];
            System.arraycopy(this.charArray, (int)offset, returnValue, 0, lengthInChars);
            out_lengthInChars[0] = lengthInChars;
            return returnValue;
        }
        return this.extension.getChars(offset - (long)this.charArray.length, lengthInChars, charSet, out_lengthInChars);
    }

    @Override
    void get(long offset, byte[] dest, int destOffset, int length) {
        if (offset < (long)this.charArray.length) {
            try {
                int n = this.conversion.javaCharsToCHARBytes(this.charArray, (int)offset, dest, destOffset, length);
            }
            catch (SQLException ea) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "get", "T2CCharByteArray, conversion exception: ", null, ea);
            }
        } else {
            this.extension.get(offset - (long)this.charArray.length, dest, destOffset, length);
        }
    }

    @Override
    byte get(long index) {
        if (index < (long)this.charArray.length) {
            return (byte)(this.charArray[(int)index] & 0xFF);
        }
        return this.extension.get(index - (long)this.charArray.length);
    }
}

