/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jndi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.resolver.EnvVariableResolver;

public class LDAPSSLSocketFactory
extends SSLSocketFactory {
    static final ThreadLocal<Properties> connectionProperties = new ThreadLocal();
    private static SSLSocketFactory defaultFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();

    public static SocketFactory getDefault() {
        return new LDAPSSLSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return defaultFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return defaultFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        Properties sslProperties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(sslProperties).createSocket(), sslProperties);
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        Properties sslProperties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(sslProperties).createSocket(s, host, port, autoClose), sslProperties);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Properties sslProperties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(sslProperties).createSocket(host, port), sslProperties);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Properties sslProperties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(sslProperties).createSocket(host, port), sslProperties);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Properties sslProperties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(sslProperties).createSocket(host, port, localHost, localPort), sslProperties);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Properties sslProperties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(sslProperties).createSocket(address, port, localAddress, localPort), sslProperties);
    }

    private SSLSocketFactory getSSLSocketFactory(@Blind(value=PropertiesBlinder.class) Properties sslProperties) throws IOException {
        return CustomSSLSocketFactory.getSSLSocketFactory(sslProperties, null, CommonDiagnosable.getInstance());
    }

    @Blind(value=PropertiesBlinder.class)
    private Properties getSSLProperties(@Blind(value=PropertiesBlinder.class) Properties userProperties) {
        Enumeration<Object> e = userProperties.keys();
        Properties sslProps = new Properties();
        sslProps.put((Object)38, "TLS");
        while (e.hasMoreElements()) {
            Object propertyValue;
            String propertyKey = (String)e.nextElement();
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.walletLocation")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.walletLocation");
                sslProps.put((Object)5, EnvVariableResolver.resolveEnvPlaceHolders((String)propertyValue, userProperties));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.walletPassword")) {
                propertyValue = (OpaqueString)userProperties.get("oracle.net.ldap.ssl.walletPassword");
                sslProps.put((Object)16, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.supportedVersions")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.supportedVersions");
                sslProps.put((Object)6, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.ssl_context_protocol")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.ssl_context_protocol");
                sslProps.put((Object)38, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.supportedCiphers")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.supportedCiphers");
                sslProps.put((Object)7, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.keyStore")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.keyStore");
                sslProps.put((Object)8, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.keyStoreType")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.keyStoreType");
                sslProps.put((Object)9, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.keyStorePassword")) {
                propertyValue = (OpaqueString)userProperties.get("oracle.net.ldap.ssl.keyStorePassword");
                sslProps.put((Object)10, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.trustStore")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.trustStore");
                sslProps.put((Object)11, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.trustStoreType")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.trustStoreType");
                sslProps.put((Object)12, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.trustStorePassword")) {
                propertyValue = (OpaqueString)userProperties.get("oracle.net.ldap.ssl.trustStorePassword");
                sslProps.put((Object)13, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.keyManagerFactory.algorithm")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.keyManagerFactory.algorithm");
                sslProps.put((Object)14, propertyValue);
                continue;
            }
            if (!propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.trustManagerFactory.algorithm")) continue;
            propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.trustManagerFactory.algorithm");
            sslProps.put((Object)15, propertyValue);
        }
        return sslProps;
    }

    private Socket initializeSSLSocket(SSLSocket sslSocket, @Blind(value=PropertiesBlinder.class) Properties sslProps) {
        String supportedProtocolsStr = (String)sslProps.get(6);
        if (supportedProtocolsStr != null && !supportedProtocolsStr.trim().isEmpty()) {
            String[] supportedProtocols = supportedProtocolsStr.split(",");
            sslSocket.setEnabledProtocols(supportedProtocols);
        } else {
            sslSocket.setEnabledProtocols(sslSocket.getSupportedProtocols());
        }
        String supportedCiphersStr = (String)sslProps.get(7);
        if (supportedCiphersStr != null && !supportedCiphersStr.trim().isEmpty()) {
            String[] supportedCiphers = supportedCiphersStr.split(",");
            sslSocket.setEnabledCipherSuites(supportedCiphers);
        } else {
            sslSocket.setEnabledCipherSuites(sslSocket.getSupportedCipherSuites());
        }
        return sslSocket;
    }
}

